/*
 * Decompiled with CFR 0.152.
 */
package de.tass;

import de.tass.exception.MultipleTargetAccountException;
import de.tass.gui.BrandingPane;
import de.tass.gui.ButtonPane;
import de.tass.gui.FileChooserPane;
import de.tass.gui.StandardMenuBar;
import de.tass.listener.KWindowListener;
import de.tass.model.ReplacementEntry;
import de.tass.utils.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class Kontenkonverter
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Properties _cfg;
    private JMenuBar _menuBar;
    private BrandingPane _brandingPane;
    private FileChooserPane _fileChooserPane;
    private ButtonPane _buttonPane;
    private List<String> _replacementFiles = new ArrayList<String>();
    private Map<Integer, ReplacementEntry> _replacements = new HashMap<Integer, ReplacementEntry>();

    private Kontenkonverter() {
        super("T&R Kontenkonverter");
        this.readConfig();
        this.setWindowStyle();
        this.updateReplacementFilesList();
        this.readReplacementFile(this._replacementFiles.get(0));
        this.createGUI();
    }

    public static void main(String[] args) {
        Kontenkonverter tassKontenkonverter = new Kontenkonverter();
        tassKontenkonverter.addWindowListener(new KWindowListener());
        tassKontenkonverter.setVisible(true);
    }

    public void updateConfig() {
        String filePath = this.getFileChooserPane().getTargetDirPath();
        if (filePath == null) {
            filePath = "";
        }
        this._cfg.put("lastTargetDir", filePath);
    }

    public void updateReplacementFilesList() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Stream<Path> paths = Files.walk(Paths.get("configs", new String[0]), new FileVisitOption[0]);){
                paths.filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(file -> {
                    boolean bl = this._replacementFiles.add(file.getFileName().toString());
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, String.format("Das Verzeichnis \"%s\" konnte nicht gefunden werden.", "configs"), "Fehler", 0);
            System.exit(0);
        }
    }

    public void readReplacementFile(String filename) {
        this._replacements = new HashMap<Integer, ReplacementEntry>();
        File replacementsFile = new File("configs/" + filename);
        int currentLineNo = 1;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(replacementsFile), "windows-1252"));){
                String currentLine = null;
                while ((currentLine = fileReader.readLine()) != null) {
                    String[] replacementStrings = currentLine.split(";", -1);
                    int sourceAccountNumber = Integer.parseInt(replacementStrings[1].trim());
                    int targetAccountNumber = Integer.parseInt(replacementStrings[3].trim());
                    ReplacementEntry entry = null;
                    if (this._replacements.containsKey(sourceAccountNumber)) {
                        entry = this._replacements.get(sourceAccountNumber);
                        if (entry.getTargetAccountNumber() != targetAccountNumber) {
                            throw new MultipleTargetAccountException();
                        }
                    } else {
                        entry = new ReplacementEntry(sourceAccountNumber, targetAccountNumber);
                    }
                    entry.addBookingKeyMapping(replacementStrings[0], replacementStrings[2]);
                    this._replacements.put(Integer.parseInt(replacementStrings[1]), entry);
                    ++currentLineNo;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, String.format("Beim Lesen der Konfigurationsdatei \"%s\" ist in Zeile %d ein Fehler aufgetreten.", filename, currentLineNo), "Fehler", 0);
            System.exit(0);
        }
    }

    public void readConfig() {
        File propFile = new File("preferences.prp");
        this._cfg = new Properties();
        if (propFile.exists() && propFile.isFile() && propFile.canRead()) {
            try {
                FileInputStream fis = new FileInputStream(propFile);
                this._cfg.load(fis);
                fis.close();
            }
            catch (IOException e) {
                Logger.log(this.getClass(), e.toString());
            }
        }
    }

    public void writeConfig() {
        File propFile = new File("preferences.prp");
        if (!propFile.exists() || propFile.isFile() && propFile.canWrite()) {
            try {
                FileOutputStream fos = new FileOutputStream(propFile);
                this._cfg.store(fos, null);
                fos.flush();
                fos.close();
            }
            catch (IOException e) {
                Logger.log(this.getClass(), e.toString());
            }
        } else {
            Logger.log(this.getClass(), "Konfiguration kann nicht geschrieben werden.");
        }
    }

    public BrandingPane getBrandingPane() {
        return this._brandingPane;
    }

    public FileChooserPane getFileChooserPane() {
        return this._fileChooserPane;
    }

    public ButtonPane getButtonPane() {
        return this._buttonPane;
    }

    public Properties getConfiguration() {
        return this._cfg;
    }

    public List<String> getReplacementFilesList() {
        return this._replacementFiles;
    }

    public Map<Integer, ReplacementEntry> getReplacements() {
        return this._replacements;
    }

    public String getConfig(String param) {
        if (this._cfg == null) {
            return null;
        }
        return this._cfg.getProperty(param);
    }

    public void setConfig(String param, String value) {
        if (this._cfg != null) {
            this._cfg.put(param, value);
        }
    }

    private void setWindowStyle() {
        try {
            this.setResizable(false);
            this.setDefaultCloseOperation(3);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.put("TitledBorder.font", new Font("Tahoma", 1, 12));
            UIManager.put("Button.font", new Font("Tahoma", 1, 12));
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            Logger.log(this.getClass(), e.toString());
        }
    }

    private void createGUI() {
        this._menuBar = new StandardMenuBar(this);
        this.setJMenuBar(this._menuBar);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this._brandingPane = new BrandingPane();
        contentPane.add((Component)this._brandingPane, "North");
        this._fileChooserPane = new FileChooserPane(this);
        contentPane.add((Component)this._fileChooserPane, "Center");
        this._buttonPane = new ButtonPane(this);
        contentPane.add((Component)this._buttonPane, "South");
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = this.getSize();
        this.setLocation(d.width / 2 - d2.width / 2, d.height / 2 - d2.height / 2);
    }
}

