/*
 * Decompiled with CFR 0.152.
 */
package de.tass.gui;

import de.tass.Kontenkonverter;
import de.tass.model.Import;
import de.tass.utils.ImageLoader;
import de.tass.utils.Logger;
import de.tass.worker.DatevCsvWriter;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ButtonPane
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final Kontenkonverter _owner;

    public ButtonPane(Kontenkonverter owner) {
        this._owner = owner;
        FlowLayout fl = new FlowLayout(2);
        fl.setHgap(10);
        this.setLayout(fl);
        this.setBorder(new EmptyBorder(0, 0, 5, 0));
        JButton startBtn = new JButton("Start");
        startBtn.setIcon(ImageLoader.loadStart());
        startBtn.setMargin(new Insets(10, 10, 10, 10));
        startBtn.setIconTextGap(10);
        startBtn.setToolTipText("Konvertierung starten");
        startBtn.setActionCommand("start-convert");
        startBtn.addActionListener(this);
        this.add(startBtn);
    }

    @Override
    public final void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("start-convert")) {
            if (this._owner.getFileChooserPane().validateEntries()) {
                this._owner.updateConfig();
                try {
                    for (File file : this._owner.getFileChooserPane().getSourceFiles()) {
                        int selection;
                        Import fileImport = new Import(file);
                        DatevCsvWriter datevWriter = new DatevCsvWriter(this._owner.getConfiguration(), this.getSourceFilePrefix(file), this._owner.getReplacements());
                        if (datevWriter.targetFileExists() && (selection = JOptionPane.showOptionDialog(this._owner, "Im Zielverzeichnis existiert bereits eine Datei mit dem Namen \"" + file.getName() + "\".\nSoll die Datei \u00fcberschrieben werden?", "Hinweis", 0, 3, null, new String[]{"Yes", "No"}, "No")) != 0) continue;
                        datevWriter.writeCsv(fileImport);
                        if (fileImport.getWorkflowStatus() == 0) continue;
                        Logger.log(this.getClass(), "Import abgebrochen: " + fileImport.getStatusMessage());
                        throw new Exception("Beim Schreiben der Daten ist ein Fehler aufgetreten.\n\n>> " + fileImport.getStatusMessage() + " <<\n" + fileImport.toString() + "\n\n" + "Bitte \u00fcberpr\u00fcfen Sie die Zieldatei und wenden Sie sich ggf. an die Contax.");
                    }
                    this._owner.getFileChooserPane().removeSourceFiles();
                    JOptionPane.showMessageDialog(this._owner, "Die Daten wurden erfolgreich\nverarbeitet und geschrieben.", "Hinweis", 1);
                }
                catch (Exception ex) {
                    Logger.log(this.getClass(), ex.toString());
                    JOptionPane.showMessageDialog(this._owner, ex.getMessage(), "Fehler", 0);
                }
            }
        } else {
            System.out.println(cmd);
        }
    }

    private final String getSourceFilePrefix(File sourceFile) {
        if (sourceFile == null) {
            return null;
        }
        return sourceFile.getName().substring(0, sourceFile.getName().lastIndexOf("."));
    }
}

