/*
 * Decompiled with CFR 0.152.
 */
package de.tass.gui;

import de.tass.gui.DropPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DragNDropFileChooserPane
extends JPanel {
    private static final long serialVersionUID = -7853323255901471057L;
    private DropPane _dropPane = new DropPane(this);
    private DefaultListModel<File> _fileModel = new DefaultListModel();
    private JList<File> _fileList = new JList<File>(this._fileModel);
    private JButton _removeButton;

    public DragNDropFileChooserPane() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.black);
        this.add((Component)this._dropPane, "West");
        this._removeButton = new JButton("Markierte entfernen");
        this._removeButton.setActionCommand("Markierte entfernen");
        this._removeButton.addActionListener(new RemoveListener());
        this._removeButton.setEnabled(false);
        JPanel removeButtonPanel = new JPanel();
        removeButtonPanel.add(this._removeButton);
        removeButtonPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        JScrollPane listScroller = new JScrollPane(this._fileList);
        JPanel listAndButtonPanel = new JPanel();
        listAndButtonPanel.setLayout(new BoxLayout(listAndButtonPanel, 1));
        listAndButtonPanel.add(listScroller);
        listAndButtonPanel.add(removeButtonPanel);
        this.add((Component)listAndButtonPanel, "Center");
        this._fileList.addListSelectionListener(new FileListListener());
        this._fileList.setCellRenderer(new FileRenderer());
    }

    protected void updateFileList(List<File> files) {
        files.stream().filter(file -> !this._fileModel.contains(file)).peek(file -> this._fileModel.add(this._fileModel.getSize(), (File)file)).count();
        this._fileList.ensureIndexIsVisible(this._fileModel.size() - 1);
    }

    protected void removeFiles() {
        this._fileModel.clear();
    }

    protected List<File> getSelectedFiles() {
        return Collections.list(this._fileModel.elements());
    }

    class FileListListener
    implements ListSelectionListener {
        FileListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (DragNDropFileChooserPane.this._fileList.getSelectedIndex() == -1) {
                    DragNDropFileChooserPane.this._removeButton.setEnabled(false);
                } else {
                    DragNDropFileChooserPane.this._removeButton.setEnabled(true);
                }
            }
        }
    }

    class FileRenderer
    extends JLabel
    implements ListCellRenderer<File> {
        private static final long serialVersionUID = -4561634162585905639L;

        FileRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends File> list, File value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(new Color(28, 62, 141));
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(value == null ? "" : value.getName());
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            Border border = null;
            if (cellHasFocus) {
                if (isSelected) {
                    border = BorderFactory.createDashedBorder(Color.black);
                }
                if (border == null) {
                    border = BorderFactory.createDashedBorder(Color.WHITE);
                }
            } else {
                border = new EmptyBorder(0, 0, 0, 0);
            }
            this.setBorder(border);
            return this;
        }
    }

    class RemoveListener
    implements ActionListener {
        RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<File> selectedValues = DragNDropFileChooserPane.this._fileList.getSelectedValuesList();
            for (File value : selectedValues) {
                DragNDropFileChooserPane.this._fileModel.removeElement(value);
                int size = DragNDropFileChooserPane.this._fileModel.getSize();
                if (size == 0) {
                    DragNDropFileChooserPane.this._removeButton.setEnabled(false);
                    continue;
                }
                DragNDropFileChooserPane.this._fileList.ensureIndexIsVisible(size);
            }
        }
    }
}

