/*
 * Decompiled with CFR 0.152.
 */
package de.tass.gui;

import de.tass.gui.DragNDropFileChooserPane;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class DropPane
extends JPanel {
    private static final long serialVersionUID = -5913829387260398333L;
    private DropTarget _dropTarget;
    private DropTargetHandler _dropTargetHandler;
    private boolean _dragOver = false;
    private DragNDropFileChooserPane _owner;
    private JLabel _message;

    public DropPane(DragNDropFileChooserPane owner) {
        this._owner = owner;
        Border dashedBorder = BorderFactory.createDashedBorder(Color.BLACK, 2.0f, 5.0f, 5.0f, false);
        EmptyBorder emptyBorder = new EmptyBorder(0, 10, 0, 10);
        this.setBorder(new CompoundBorder(emptyBorder, dashedBorder));
        this.setLayout(new GridBagLayout());
        this._message = new JLabel("Hier Dateien ablegen");
        this._message.setBorder(emptyBorder);
        this._message.setFont(new Font("Tahoma", 1, 12));
        this.add(this._message);
    }

    protected DropTarget getMyDropTarget() {
        if (this._dropTarget == null) {
            this._dropTarget = new DropTarget(this, 3, null);
        }
        return this._dropTarget;
    }

    protected DropTargetHandler getDropTargetHandler() {
        if (this._dropTargetHandler == null) {
            this._dropTargetHandler = new DropTargetHandler();
        }
        return this._dropTargetHandler;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        try {
            this.getMyDropTarget().addDropTargetListener(this.getDropTargetHandler());
        }
        catch (TooManyListenersException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.getMyDropTarget().removeDropTargetListener(this.getDropTargetHandler());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this._dragOver) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(new Color(0, 255, 0, 64));
            g2d.fill(new Rectangle(this.getWidth(), this.getHeight()));
            g2d.dispose();
        }
    }

    protected void importFiles(final List<File> files) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DropPane.this._owner.updateFileList(files.stream().filter(file -> file.getName().endsWith(".csv")).collect(Collectors.toList()));
            }
        };
        SwingUtilities.invokeLater(run);
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        protected DropTargetHandler() {
        }

        protected void processDrag(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrag(1);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            this.processDrag(dtde);
            DropPane.this.repaint();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            this.processDrag(dtde);
            DropPane.this.repaint();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            DropPane.this.repaint();
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Transferable transferable = dtde.getTransferable();
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(dtde.getDropAction());
                try {
                    List transferData = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    if (transferData != null && transferData.size() > 0) {
                        DropPane.this.importFiles(transferData);
                        dtde.dropComplete(true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                dtde.rejectDrop();
            }
        }
    }
}

