/*
 * Decompiled with CFR 0.152.
 */
package de.tass.gui;

import de.tass.Kontenkonverter;
import de.tass.gui.DragNDropFileChooserPane;
import de.tass.utils.Constants;
import de.tass.utils.ImageLoader;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class FileChooserPane
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Dimension STANDARD_PANEL_DIM = new Dimension(500, 50);
    private File _selectedTargetDir;
    private final DragNDropFileChooserPane _sourceFilesField;
    private final JComboBox<String> _selectReplacementFileField;
    private final JTextField _targetDirField;
    private final Kontenkonverter _owner;

    public FileChooserPane(Kontenkonverter owner) {
        this._owner = owner;
        if (this._owner.getConfig("lastTargetDir") != null && this._owner.getConfig("lastTargetDir").length() > 0) {
            this._selectedTargetDir = new File(this._owner.getConfig("lastTargetDir"));
        }
        this.setLayout(new BoxLayout(this, 1));
        CompoundBorder panelBorder = new CompoundBorder(Constants.INNER_FRAME_BORDER, new TitledBorder(null, "Dateien", 1, 2));
        this.setBorder(new CompoundBorder(panelBorder, Constants.INNER_FRAME_BORDER));
        this._sourceFilesField = new DragNDropFileChooserPane();
        this.add(this._sourceFilesField);
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this._selectReplacementFileField = new JComboBox<String>((String[])this._owner.getReplacementFilesList().stream().map(fileName -> fileName.split(".csv")[0]).toArray(String[]::new));
        this.add(this.createSelectPanel("Konfiguration:", this._selectReplacementFileField, "select-replacement-file"));
        this._targetDirField = new JTextField("");
        if (this._selectedTargetDir != null && this._selectedTargetDir.exists()) {
            this._targetDirField.setText(this._selectedTargetDir.getAbsolutePath());
        }
        this.add(this.createFilePanel("Zielverzeichnis:", this._targetDirField, ImageLoader.loadOpenFile(), "select-target-file", "Zielverzeichnis ausw\u00e4hlen"));
    }

    public final List<File> getSourceFiles() {
        return this._sourceFilesField.getSelectedFiles();
    }

    public final String getTargetDirPath() {
        if (this._selectedTargetDir == null) {
            return null;
        }
        return this._selectedTargetDir.getAbsolutePath();
    }

    public final void removeSourceFiles() {
        this._sourceFilesField.removeFiles();
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        this.updateSelectedFile();
        if ("select-target-file".equals(cmd)) {
            fileChooser.setFileSelectionMode(1);
            if (this._selectedTargetDir != null) {
                fileChooser.setCurrentDirectory(this._selectedTargetDir);
            }
            if (fileChooser.showOpenDialog(this.getParent()) == 0) {
                this._selectedTargetDir = fileChooser.getSelectedFile();
                this._targetDirField.setText(this._selectedTargetDir.getAbsolutePath());
            }
        } else if ("select-replacement-file".equals(cmd)) {
            String selectedReplacementFileName = (String)this._selectReplacementFileField.getSelectedItem();
            this._owner.readReplacementFile(String.valueOf(selectedReplacementFileName) + ".csv");
        } else {
            System.out.println(cmd);
        }
    }

    public final boolean validateEntries() {
        if (this._sourceFilesField.getSelectedFiles().isEmpty()) {
            JOptionPane.showMessageDialog(this._owner, "Bitte w\u00e4hlen Sie mindestens eine Quelldatei aus.", "Hinweis", 2);
            return false;
        }
        if (this._selectedTargetDir == null || !this._selectedTargetDir.exists() || !this._selectedTargetDir.canWrite()) {
            JOptionPane.showMessageDialog(this._owner, "Das Zielverzeichnis exisitiert nicht\noder ist nicht beschreibbar.", "Hinweis", 2);
            return false;
        }
        return true;
    }

    private void updateSelectedFile() {
        File file = new File(this._targetDirField.getText());
        this._selectedTargetDir = file.exists() && file.isDirectory() ? file : null;
    }

    private JPanel createSelectPanel(String label, JComboBox<String> comboBox, String cmd) {
        comboBox.setActionCommand(cmd);
        comboBox.addActionListener(this);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        panel.setPreferredSize(STANDARD_PANEL_DIM);
        JLabel descriptionLabel = new JLabel(label);
        descriptionLabel.setFont(new Font("Tahoma", 1, 12));
        panel.add(descriptionLabel);
        panel.add(comboBox);
        return panel;
    }

    private JPanel createFilePanel(String label, JTextField textField, ImageIcon icon, String cmd, String tooltip) {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 2));
        innerPanel.add(textField);
        innerPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        JButton btn = new JButton("", icon);
        btn.setMargin(new Insets(10, 10, 10, 10));
        btn.setToolTipText(tooltip);
        btn.setActionCommand(cmd);
        btn.addActionListener(this);
        innerPanel.add(btn);
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new GridLayout(0, 1));
        outerPanel.setPreferredSize(STANDARD_PANEL_DIM);
        JLabel descriptionLabel = new JLabel(label);
        descriptionLabel.setFont(new Font("Tahoma", 1, 12));
        outerPanel.add(descriptionLabel);
        outerPanel.add(innerPanel);
        return outerPanel;
    }
}

