/*
 * Decompiled with CFR 0.152.
 */
package de.tass.model;

import java.io.File;

public class Import {
    public static final int OK = 0;
    public static final int SOURCEFILE_NOT_READABLE = 1;
    public static final int SOURCEFILE_UNPARSABLE = 2;
    public static final int TARGETFILE_NOT_WRITABLE = 10;
    public static final int NO_MATCHING_BOOKINGKEY = 20;
    public static final int MULTIPLE_MATCHING_BOOKINGKEY = 30;
    public static final int ERROR_UNKNOWN = 99;
    private final File _sourceFile;
    private int _workflowStatus = 0;
    private int _errorLine = 0;

    public Import(File sourceFile) {
        this._sourceFile = sourceFile;
    }

    public final File getSourceFile() {
        return this._sourceFile;
    }

    public final int getWorkflowStatus() {
        return this._workflowStatus;
    }

    public final void setWorkflowStatus(int workflowStatus) {
        this._workflowStatus = workflowStatus;
    }

    public int getErrorLine() {
        return this._errorLine;
    }

    public void setErrorLine(int errorLine) {
        this._errorLine = errorLine;
    }

    public final String getStatusMessage() {
        String msg;
        switch (this._workflowStatus) {
            case 0: {
                msg = "Die Daten wurden erfolgreich verarbeitet.";
                break;
            }
            case 1: {
                msg = "Die Quelldatei konnte nicht ge\u00f6ffnet werden.";
                break;
            }
            case 2: {
                msg = "Der Aufbau der Quelldatei ist fehlerhaft.";
                break;
            }
            case 20: {
                msg = "Es konnte kein passender Buchungsschl\u00fcssel gefunden werden.";
                break;
            }
            case 30: {
                msg = "Es wurde kein eindeutiger Buchungsschl\u00fcssel gefunden.";
                break;
            }
            default: {
                msg = "Es ist ein unbekannter Fehler aufgetreten.";
            }
        }
        return msg;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(2);
        builder.append("Datei: " + this.getSourceFile().getName() + "\n" + "Fehler: " + this.getWorkflowStatus());
        if (this.getErrorLine() > 0) {
            builder.append("\nZeile: " + this.getErrorLine());
        }
        return builder.toString();
    }
}

