/*
 * Decompiled with CFR 0.152.
 */
package de.tass.worker;

import de.tass.exception.MultipleBookingKeyException;
import de.tass.exception.NoMatchingBookingKeyFoundException;
import de.tass.model.Import;
import de.tass.model.ReplacementEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;

public class DatevCsvWriter {
    private static final String CSV_SEPARATOR = ";";
    private static final String CSV_FILE_SUFFIX = "csv";
    private static final int ACCOUNT_COLUMN = 6;
    private static final int CONTRA_ACCOUNT_COLUMN = 7;
    private static final int BOOKING_KEY_COLUMN = 8;
    private Map<Integer, ReplacementEntry> _replacements;
    private final File _targetFile;

    public DatevCsvWriter(Properties cfg, String targetFilePrefix, Map<Integer, ReplacementEntry> replacements) {
        this._targetFile = new File(String.valueOf(cfg.getProperty("lastTargetDir")) + System.getProperty("file.separator") + targetFilePrefix + "." + CSV_FILE_SUFFIX);
        this._replacements = replacements;
    }

    /*
     * Exception decompiling
     */
    public final void writeCsv(Import fileImport) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final boolean targetFileExists() {
        return this._targetFile.exists();
    }

    private void convertFile(BufferedWriter wr, File sourceFile) throws IOException, NoMatchingBookingKeyFoundException, MultipleBookingKeyException {
        int counter = 0;
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFile), "windows-1252"));){
                String csvLine = null;
                while ((csvLine = fileReader.readLine()) != null) {
                    if (counter < 2) {
                        wr.append(csvLine);
                        wr.append("\n");
                        ++counter;
                        continue;
                    }
                    wr.append(this.convertCsvLine(csvLine));
                    wr.append("\n");
                    ++counter;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoMatchingBookingKeyFoundException e) {
            e.setRowNumber(counter + 1);
            throw e;
        }
        catch (MultipleBookingKeyException e) {
            e.setRowNumber(counter + 1);
            throw e;
        }
    }

    private String convertCsvLine(String csvLine) throws NoMatchingBookingKeyFoundException, MultipleBookingKeyException {
        CharSequence[] csvLineColumns = csvLine.split(CSV_SEPARATOR);
        csvLineColumns = this.checkForReplacements((String[])csvLineColumns);
        return String.join((CharSequence)CSV_SEPARATOR, csvLineColumns);
    }

    private String[] checkForReplacements(String[] csvLineColumns) throws NoMatchingBookingKeyFoundException, MultipleBookingKeyException {
        int accountNumber = Integer.parseInt(csvLineColumns[6].replace("\"", ""));
        int contraAccountNumber = Integer.parseInt(csvLineColumns[7].replace("\"", ""));
        String bookingKey = csvLineColumns[8].replace("\"", "");
        ReplacementEntry accountReplacementEntry = this._replacements.get(accountNumber);
        ReplacementEntry contraAccountReplacementEntry = this._replacements.get(contraAccountNumber);
        if (accountReplacementEntry == null && contraAccountReplacementEntry == null) {
            return csvLineColumns;
        }
        if (accountReplacementEntry != null && contraAccountReplacementEntry == null) {
            return this.replaceValuesInCSVLine(csvLineColumns, accountReplacementEntry, bookingKey, 6);
        }
        if (accountReplacementEntry == null && contraAccountReplacementEntry != null) {
            return this.replaceValuesInCSVLine(csvLineColumns, contraAccountReplacementEntry, bookingKey, 7);
        }
        String newBookingKey = null;
        if (accountReplacementEntry.getBookingKeyMappings().containsKey(bookingKey)) {
            newBookingKey = accountReplacementEntry.getBookingKeyMappings().get(bookingKey);
        }
        if (contraAccountReplacementEntry.getBookingKeyMappings().containsKey(bookingKey)) {
            if (newBookingKey == null) {
                newBookingKey = contraAccountReplacementEntry.getBookingKeyMappings().get(bookingKey);
            } else if (!newBookingKey.equals(contraAccountReplacementEntry.getBookingKeyMappings().get(bookingKey))) {
                throw new MultipleBookingKeyException();
            }
        } else if (newBookingKey == null) {
            throw new NoMatchingBookingKeyFoundException();
        }
        csvLineColumns[6] = String.valueOf(accountReplacementEntry.getTargetAccountNumber());
        csvLineColumns[7] = String.valueOf(contraAccountReplacementEntry.getTargetAccountNumber());
        csvLineColumns[8] = newBookingKey;
        return csvLineColumns;
    }

    private String[] replaceValuesInCSVLine(String[] csvLineColumns, ReplacementEntry replacement, String bookingKey, int targetColumn) throws NoMatchingBookingKeyFoundException {
        if (!replacement.getBookingKeyMappings().containsKey(bookingKey)) {
            throw new NoMatchingBookingKeyFoundException();
        }
        csvLineColumns[targetColumn] = String.valueOf(replacement.getTargetAccountNumber());
        csvLineColumns[8] = replacement.getBookingKeyMappings().get(bookingKey);
        return csvLineColumns;
    }
}

