/*
 * Decompiled with CFR 0.152.
 */
package de.tass;

import de.tass.gui.BrandingPane;
import de.tass.gui.ButtonPane;
import de.tass.gui.FileChooserPane;
import de.tass.gui.StandardMenuBar;
import de.tass.listener.KWindowListener;
import de.tass.utils.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class Konverter
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Properties _cfg;
    private JMenuBar _menuBar;
    private BrandingPane _brandingPane;
    private FileChooserPane _fileChooserPane;
    private ButtonPane _buttonPane;

    private Konverter() {
        super("TASS - Datei Konverter");
        this.readConfig();
        this.setWindowStyle();
        this.createGUI();
    }

    public static void main(String[] args) {
        Konverter tassKonverter = new Konverter();
        tassKonverter.addWindowListener(new KWindowListener());
        tassKonverter.setVisible(true);
    }

    public void updateConfig() {
        String filePath = this.getFileChooserPane().getSourceFilePath();
        if (filePath == null) {
            filePath = "";
        }
        this._cfg.put("lastSourceFile", filePath);
        filePath = this.getFileChooserPane().getTargetDirPath();
        if (filePath == null) {
            filePath = "";
        }
        this._cfg.put("lastTargetDir", filePath);
    }

    public void readConfig() {
        File propFile = new File("preferences.prp");
        this._cfg = new Properties();
        if (propFile.exists() && propFile.isFile() && propFile.canRead()) {
            try {
                FileInputStream fis = new FileInputStream(propFile);
                this._cfg.load(fis);
                fis.close();
            }
            catch (IOException e) {
                Logger.log(this.getClass(), e.toString());
            }
        }
    }

    public void writeConfig() {
        File propFile = new File("preferences.prp");
        if (!propFile.exists() || propFile.isFile() && propFile.canWrite()) {
            try {
                FileOutputStream fos = new FileOutputStream(propFile);
                this._cfg.store(fos, null);
                fos.flush();
                fos.close();
            }
            catch (IOException e) {
                Logger.log(this.getClass(), e.toString());
            }
        } else {
            Logger.log(this.getClass(), "Konfiguration kann nicht geschrieben werden.");
        }
    }

    public BrandingPane getBrandingPane() {
        return this._brandingPane;
    }

    public FileChooserPane getFileChooserPane() {
        return this._fileChooserPane;
    }

    public ButtonPane getButtonPane() {
        return this._buttonPane;
    }

    public Properties getConfiguration() {
        return this._cfg;
    }

    public String getConfig(String param) {
        if (this._cfg == null) {
            return null;
        }
        return this._cfg.getProperty(param);
    }

    public void setConfig(String param, String value) {
        if (this._cfg != null) {
            this._cfg.put(param, value);
        }
    }

    private void setWindowStyle() {
        try {
            this.setResizable(false);
            this.setDefaultCloseOperation(3);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.put("TitledBorder.font", new Font("Tahoma", 1, 12));
            UIManager.put("Button.font", new Font("Tahoma", 1, 12));
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            Logger.log(this.getClass(), e.toString());
        }
    }

    private void createGUI() {
        this._menuBar = new StandardMenuBar(this);
        this.setJMenuBar(this._menuBar);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this._brandingPane = new BrandingPane();
        contentPane.add((Component)this._brandingPane, "North");
        this._fileChooserPane = new FileChooserPane(this);
        contentPane.add((Component)this._fileChooserPane, "Center");
        this._buttonPane = new ButtonPane(this);
        contentPane.add((Component)this._buttonPane, "South");
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = this.getSize();
        this.setLocation(d.width / 2 - d2.width / 2, d.height / 2 - d2.height / 2);
    }
}

