/*
 * Decompiled with CFR 0.152.
 */
package de.tass.gui;

import de.tass.Konverter;
import de.tass.model.Import;
import de.tass.utils.ImageLoader;
import de.tass.utils.Logger;
import de.tass.worker.CollmexParser;
import de.tass.worker.DatevCsvWriter;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ButtonPane
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final Konverter _owner;

    public ButtonPane(Konverter owner) {
        this._owner = owner;
        FlowLayout fl = new FlowLayout(2);
        fl.setHgap(10);
        this.setLayout(fl);
        this.setBorder(new EmptyBorder(0, 0, 5, 0));
        JButton startBtn = new JButton("Start");
        startBtn.setIcon(ImageLoader.loadStart());
        startBtn.setMargin(new Insets(10, 10, 10, 10));
        startBtn.setIconTextGap(10);
        startBtn.setToolTipText("Konvertierung starten");
        startBtn.setActionCommand("start-convert");
        startBtn.addActionListener(this);
        this.add(startBtn);
    }

    @Override
    public final void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("start-convert")) {
            if (this._owner.getFileChooserPane().validateEntries()) {
                this._owner.updateConfig();
                try {
                    int selection;
                    CollmexParser parser = new CollmexParser(this._owner.getConfiguration());
                    Import cImport = parser.parse();
                    if (!cImport.hasValidData() || cImport.getWorkflowStatus() != 0) {
                        Logger.log(this.getClass(), "Import abgebrochen: " + cImport.getStatusMessage());
                        throw new Exception("Beim Verarbeiten der Daten ist ein Fehler aufgetreten.\n\n>> " + cImport.getStatusMessage() + " <<\n" + cImport.toString() + "\n\n" + "Bitte \u00fcberpr\u00fcfen Sie die Quelldatei und wenden Sie sich ggf. an die Contax.");
                    }
                    DatevCsvWriter datevWriter = new DatevCsvWriter(this._owner.getConfiguration(), this._owner.getFileChooserPane().getSourceFilePrefix());
                    if (datevWriter.targetFileExists() && (selection = JOptionPane.showOptionDialog(this._owner, "Die Zieldatei exisitiert bereits.\nSoll die Datei \u00fcberschrieben werden?", "Hinweis", 0, 3, null, new String[]{"Yes", "No"}, "No")) != 0) {
                        return;
                    }
                    datevWriter.writeCsv(cImport);
                    if (cImport.getWorkflowStatus() != 0) {
                        Logger.log(this.getClass(), "Import abgebrochen: " + cImport.getStatusMessage());
                        throw new Exception("Beim Schreiben der Daten ist ein Fehler aufgetreten.\n\n>> " + cImport.getStatusMessage() + " <<\n" + cImport.toString() + "\n\n" + "Bitte \u00fcberpr\u00fcfen Sie die Zieldatei und wenden Sie sich ggf. an die Contax.");
                    }
                    JOptionPane.showMessageDialog(this._owner, "Die Daten wurden erfolgreich\nverarbeitet und geschrieben.", "Hinweis", 1);
                }
                catch (Exception ex) {
                    Logger.log(this.getClass(), ex.toString());
                    JOptionPane.showMessageDialog(this._owner, ex.getMessage(), "Fehler", 0);
                }
            }
        } else {
            System.out.println(cmd);
        }
    }
}

