/*
 * Decompiled with CFR 0.152.
 */
package de.tass.gui;

import de.tass.Konverter;
import de.tass.utils.Constants;
import de.tass.utils.ImageLoader;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class FileChooserPane
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Dimension STANDARD_PANEL_DIM = new Dimension(380, 50);
    private File _selectedSourceFile;
    private File _selectedTargetDir;
    private final JTextField _sourceFileField;
    private final JTextField _targetDirField;
    private final Konverter _owner;

    public FileChooserPane(Konverter owner) {
        this._owner = owner;
        if (this._owner.getConfig("lastSourceFile") != null && this._owner.getConfig("lastSourceFile").length() > 0) {
            this._selectedSourceFile = new File(this._owner.getConfig("lastSourceFile"));
        }
        if (this._owner.getConfig("lastTargetDir") != null && this._owner.getConfig("lastTargetDir").length() > 0) {
            this._selectedTargetDir = new File(this._owner.getConfig("lastTargetDir"));
        }
        this.setLayout(new BoxLayout(this, 1));
        CompoundBorder panelBorder = new CompoundBorder(Constants.INNER_FRAME_BORDER, new TitledBorder(null, "Dateien", 1, 2));
        this.setBorder(new CompoundBorder(panelBorder, Constants.INNER_FRAME_BORDER));
        this._sourceFileField = new JTextField("");
        if (this._selectedSourceFile != null && this._selectedSourceFile.getParentFile().exists()) {
            this._sourceFileField.setText(this._selectedSourceFile.getAbsolutePath());
        }
        this.add(this.createFilePanel("Quelldatei:", this._sourceFileField, ImageLoader.loadOpenFile(), "select-source-file", "Quelldatei ausw\u00e4hlen"));
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this._targetDirField = new JTextField("");
        if (this._selectedTargetDir != null && this._selectedTargetDir.exists()) {
            this._targetDirField.setText(this._selectedTargetDir.getAbsolutePath());
        }
        this.add(this.createFilePanel("Zielverzeichnis:", this._targetDirField, ImageLoader.loadOpenFile(), "select-target-file", "Zielverzeichnis ausw\u00e4hlen"));
    }

    public final String getSourceFilePath() {
        if (this._selectedSourceFile == null) {
            return null;
        }
        return this._selectedSourceFile.getAbsolutePath();
    }

    public final String getSourceFilePrefix() {
        if (this._selectedSourceFile == null) {
            return null;
        }
        return this._selectedSourceFile.getName().substring(0, this._selectedSourceFile.getName().lastIndexOf("."));
    }

    public final String getTargetDirPath() {
        if (this._selectedTargetDir == null) {
            return null;
        }
        return this._selectedTargetDir.getAbsolutePath();
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        this.updateSelectedFiles();
        if ("select-source-file".equals(cmd)) {
            fileChooser.setFileSelectionMode(0);
            if (this._selectedSourceFile != null) {
                fileChooser.setCurrentDirectory(this._selectedSourceFile);
            }
            if (fileChooser.showOpenDialog(this.getParent()) == 0) {
                this._selectedSourceFile = fileChooser.getSelectedFile();
                this._sourceFileField.setText(this._selectedSourceFile.getAbsolutePath());
            }
        } else if ("select-target-file".equals(cmd)) {
            fileChooser.setFileSelectionMode(1);
            if (this._selectedTargetDir != null) {
                fileChooser.setCurrentDirectory(this._selectedTargetDir);
            }
            if (fileChooser.showOpenDialog(this.getParent()) == 0) {
                this._selectedTargetDir = fileChooser.getSelectedFile();
                this._targetDirField.setText(this._selectedTargetDir.getAbsolutePath());
            }
        } else {
            System.out.println(cmd);
        }
    }

    public final boolean validateEntries() {
        if (this._selectedSourceFile == null || !this._selectedSourceFile.exists() || !this._selectedSourceFile.canRead()) {
            JOptionPane.showMessageDialog(this._owner, "Die Quelldatei existiert nicht\noder ist nicht lesbar.", "Hinweis", 2);
            return false;
        }
        if (this._selectedTargetDir == null || !this._selectedTargetDir.exists() || !this._selectedTargetDir.canWrite()) {
            JOptionPane.showMessageDialog(this._owner, "Das Zielverzeichnis exisitiert nicht\noder ist nicht beschreibbar.", "Hinweis", 2);
            return false;
        }
        return true;
    }

    private void updateSelectedFiles() {
        File file = new File(this._sourceFileField.getText());
        this._selectedSourceFile = file.exists() && file.isFile() && file.canRead() ? file : null;
        file = new File(this._targetDirField.getText());
        this._selectedTargetDir = file.exists() && file.isDirectory() ? file : null;
    }

    private JPanel createFilePanel(String label, JTextField textField, ImageIcon icon, String cmd, String tooltip) {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 2));
        innerPanel.add(textField);
        innerPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        JButton btn = new JButton("", icon);
        btn.setMargin(new Insets(10, 10, 10, 10));
        btn.setToolTipText(tooltip);
        btn.setActionCommand(cmd);
        btn.addActionListener(this);
        innerPanel.add(btn);
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new GridLayout(0, 1));
        outerPanel.setPreferredSize(STANDARD_PANEL_DIM);
        JLabel descriptionLabel = new JLabel(label);
        descriptionLabel.setFont(new Font("Tahoma", 1, 12));
        outerPanel.add(descriptionLabel);
        outerPanel.add(innerPanel);
        return outerPanel;
    }
}

