/*
 * Decompiled with CFR 0.152.
 */
package de.tass.model;

import de.tass.utils.Logger;
import de.tass.utils.SteuerUtil;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class Buchung {
    private static final NumberFormat NUMBER_FORMATTER = NumberFormat.getNumberInstance(Locale.GERMAN);
    private final DateTimeFormatter _dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private int _itemIndex = 0;
    private int _kundenID;
    private String _name;
    private int _kontoNr = 123456;
    private int _gegenKontoNr = 123456;
    private String _rechnungsNr;
    private int _belegNr;
    private LocalDate _datum;
    private String _zahlungsbedingung;
    private LocalDate _faelligkeit;
    private int _verzug;
    private String _mahnungen;
    private LocalDate _fristende;
    private double _betrag;
    private double _bezahlt;
    private double _offen;
    private double _ust = 19.0;
    private String _waehrung = "EUR";
    private double _kurs = 0.0;
    private String _raffung = "X";
    private String _text = "X";
    private String _vorlauf = "X";
    private int _buchungsSatzNr = 0;
    private String _ausgleichsKennzeichen = "X";

    public final int getKundenID() {
        return this._kundenID;
    }

    public final void setKundenID(int kundenID) {
        this._kundenID = kundenID;
    }

    public final void setKundenID(String kundenID) {
        this._kundenID = kundenID != null ? Integer.parseInt(kundenID) : 0;
    }

    public final String getName() {
        return this._name;
    }

    public final void setName(String name) {
        this._name = name;
    }

    public final int getKontoNr() {
        return this._kontoNr;
    }

    public final void setKontoNr(String kontoNr) {
        this._kontoNr = kontoNr != null ? Integer.parseInt(kontoNr) : 0;
    }

    public final int getGegenKontoNr() {
        return this._gegenKontoNr;
    }

    public final void setGegenKontoNr(String kontoNr) {
        this._gegenKontoNr = kontoNr != null ? Integer.parseInt(kontoNr) : 0;
    }

    public final String getRechnungsNr() {
        return this._rechnungsNr;
    }

    public final void setRechnungsNr(String rechnungsNr) {
        this._rechnungsNr = rechnungsNr;
    }

    public final int getBelegNr() {
        return this._belegNr;
    }

    public final void setBelegNr(String belegNr) {
        this._belegNr = belegNr != null ? Integer.parseInt(belegNr) : 0;
    }

    public final LocalDate getDatum() {
        return this._datum;
    }

    public final void setDatum(String datum) {
        if (datum != null) {
            this._datum = LocalDate.parse(datum, this._dateFormatter);
            this._ust = SteuerUtil.getUmsatzsteuerByDate(this._datum);
        } else {
            this._datum = null;
        }
    }

    public final String getZahlungsbedingung() {
        return this._zahlungsbedingung;
    }

    public final void setZahlungsbedingung(String zahlungsbedingung) {
        this._zahlungsbedingung = zahlungsbedingung;
    }

    public final LocalDate getFaelligkeit() {
        return this._faelligkeit;
    }

    public final void setFaelligkeit(String faelligkeit) {
        this._faelligkeit = faelligkeit != null ? LocalDate.parse(faelligkeit, this._dateFormatter) : null;
    }

    public final int getVerzug() {
        return this._verzug;
    }

    public final void setVerzug(String verzug) {
        this._verzug = verzug != null ? Integer.parseInt(verzug) : 0;
    }

    public final String getMahnungen() {
        return this._mahnungen;
    }

    public final void setMahnungen(String mahnungen) {
        this._mahnungen = mahnungen;
    }

    public final LocalDate getFristende() {
        return this._fristende;
    }

    public final void setFristende(String fristende) {
        this._fristende = fristende != null ? LocalDate.parse(fristende, this._dateFormatter) : null;
    }

    public final double getBetrag() {
        return this._betrag;
    }

    public final void setBetrag(String betrag) {
        try {
            this._betrag = betrag != null ? NUMBER_FORMATTER.parse(betrag).doubleValue() : 0.0;
        }
        catch (ParseException pe) {
            Logger.log(this.getClass(), pe.toString());
        }
    }

    public final double getBezahlt() {
        return this._bezahlt;
    }

    public final void setBezahlt(String bezahlt) {
        try {
            this._bezahlt = bezahlt != null ? NUMBER_FORMATTER.parse(bezahlt).doubleValue() : 0.0;
        }
        catch (ParseException pe) {
            Logger.log(this.getClass(), pe.toString());
        }
    }

    public final double getOffen() {
        return this._offen;
    }

    public final void setOffen(String offen) {
        try {
            this._offen = offen != null ? NUMBER_FORMATTER.parse(offen).doubleValue() : 0.0;
        }
        catch (ParseException pe) {
            Logger.log(this.getClass(), pe.toString());
        }
    }

    public final String getWaehrung() {
        return this._waehrung;
    }

    public final void setWaehrung(String waehrung) {
        this._waehrung = waehrung;
    }

    public final double getUst() {
        return this._ust;
    }

    public final void setUst(double ust) {
        this._ust = ust;
    }

    public final double getKurs() {
        return this._kurs;
    }

    public final void setKurs(double kurs) {
        this._kurs = kurs;
    }

    public final String getRaffung() {
        return this._raffung;
    }

    public final void setRaffung(String raffung) {
        this._raffung = raffung;
    }

    public final String getText() {
        return this._text;
    }

    public final void setText(String text) {
        this._text = text;
    }

    public final String getVorlauf() {
        return this._vorlauf;
    }

    public final void setVorlauf(String vorlauf) {
        this._vorlauf = vorlauf;
    }

    public final int getBuchungsSatzNr() {
        return this._buchungsSatzNr;
    }

    public final void setBuchungsSatzNr(int buchungsSatzNr) {
        this._buchungsSatzNr = buchungsSatzNr;
    }

    public final String getAusgleichsKennzeichen() {
        return this._ausgleichsKennzeichen;
    }

    public final void setAusgleichsKennzeichen(String ausgleicheskz) {
        this._ausgleichsKennzeichen = ausgleicheskz;
    }

    public final void addItem(String item, String prefix) {
        this.addItem(item, prefix, 1);
    }

    public final void addItem(String item, String prefix, int increment) {
        if (!item.startsWith(prefix)) {
            switch (this._itemIndex) {
                case 0: {
                    this.setKundenID(item);
                    break;
                }
                case 1: {
                    this.setName(item);
                    break;
                }
                case 2: {
                    this.setRechnungsNr(item);
                    break;
                }
                case 3: {
                    this.setBelegNr(item);
                    break;
                }
                case 4: {
                    this.setDatum(item);
                    break;
                }
                case 5: {
                    this.setZahlungsbedingung(item);
                    break;
                }
                case 6: {
                    this.setFaelligkeit(item);
                    break;
                }
                case 7: {
                    this.setVerzug(item);
                    break;
                }
                case 8: {
                    this.setMahnungen(item);
                    break;
                }
                case 9: {
                    this.setFristende(item);
                    break;
                }
                case 10: {
                    this.setBetrag(item);
                    break;
                }
                case 11: {
                    this.setBezahlt(item);
                    break;
                }
                case 12: {
                    this.setOffen(item);
                    break;
                }
            }
        }
        this._itemIndex += increment;
    }

    public final boolean isValid() {
        boolean isValid;
        boolean bl = isValid = this._kundenID > 0 && this._name != null && this._belegNr > 0 && this._datum != null && this._zahlungsbedingung != null && this._betrag != 0.0;
        if (!isValid) {
            Logger.log(this.getClass(), String.valueOf(this.toString()) + " ist ung\u00fcltig");
        }
        return isValid;
    }

    public final String toString() {
        return "Kundenid: " + this.getKundenID() + "\n" + "Name: " + this.getName() + "\n" + "Rechnungs-Nr: " + this.getRechnungsNr() + "\n" + "Beleg-Nr: " + this.getBelegNr() + "\n" + "Datum: " + this.getDatum() + "\n" + "Zahlungsbedingung: " + this.getZahlungsbedingung() + "\n" + "F\u00e4lligkeit: " + this.getFaelligkeit() + "\n" + "Verzug: " + this.getVerzug() + "\n" + "Mahnung: " + this.getMahnungen() + "\n" + "Betrag: " + this.getBetrag() + "\n" + "Bezahlt: " + this.getBezahlt() + "\n" + "Offen: " + this.getOffen();
    }
}

