/*
 * Decompiled with CFR 0.152.
 */
package de.tass.model;

import de.tass.model.Buchung;
import de.tass.utils.Logger;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

public class Mandant {
    private final DateTimeFormatter _dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private int _id;
    private String _name;
    private LocalDate _date;
    private ArrayList<Buchung> _buchungsliste;

    public final int getId() {
        return this._id;
    }

    public final void setId(String mandantId) {
        this._id = mandantId != null ? Integer.parseInt(mandantId) : 0;
    }

    public final String getName() {
        return this._name;
    }

    public final void setName(String mandant) {
        this._name = mandant;
    }

    public final LocalDate getDate() {
        return this._date;
    }

    public final void setDate(String importDate) {
        this._date = importDate != null ? LocalDate.parse(importDate, this._dateFormatter) : null;
    }

    public final void setDate(LocalDate importDate) {
        this._date = importDate != null ? importDate : null;
    }

    public final ArrayList<Buchung> getBuchungsliste() {
        return this._buchungsliste;
    }

    public final void setBuchungen(ArrayList<Buchung> buchungen) {
        this._buchungsliste = buchungen;
    }

    public final void addBuchung(Buchung newBuchung) {
        if (this._buchungsliste == null) {
            this._buchungsliste = new ArrayList();
        }
        this._buchungsliste.add(newBuchung);
    }

    public final boolean isValid(boolean completeData) {
        boolean isMandantValid;
        boolean isBuchungenValid = true;
        boolean bl = isMandantValid = this._id > 0 && this._name != null;
        if (!isMandantValid) {
            Logger.log(this.getClass(), String.valueOf(this.toString()) + " ist ung\u00fcltig");
        }
        if (completeData) {
            if (this._buchungsliste != null && !this._buchungsliste.isEmpty()) {
                int i = 0;
                while (i < this._buchungsliste.size()) {
                    isBuchungenValid &= this._buchungsliste.get(i).isValid();
                    ++i;
                }
            } else {
                isBuchungenValid = false;
            }
        }
        return isMandantValid && isBuchungenValid;
    }

    public final String toString() {
        return "Datum: " + this.getDate() + "\n" + "Mandanten-ID: " + this.getId() + "\n" + "Name: " + this.getName();
    }
}

