/*
 * Decompiled with CFR 0.152.
 */
package de.tass.utils;

import de.tass.Konverter;
import de.tass.utils.Logger;
import java.net.URL;
import javax.swing.ImageIcon;

public final class ImageLoader {
    private static final String BRANDING_IMAGE = "resource/banner.png";
    private static final String CLOSE_IMAGE = "resource/close.png";
    private static final String EXIT_IMAGE = "resource/exit.png";
    private static final String OPEN_FILE_IMAGE = "resource/open-file.gif";
    private static final String QUESTIONMARK_IMAGE = "resource/question-mark.png";
    private static final String START_IMAGE = "resource/flag-green.png";

    private ImageLoader() {
    }

    public static ImageIcon loadBranding() {
        return ImageLoader.loadResource(BRANDING_IMAGE);
    }

    public static ImageIcon loadExit() {
        return ImageLoader.loadResource(EXIT_IMAGE);
    }

    public static ImageIcon loadOpenFile() {
        return ImageLoader.loadResource(OPEN_FILE_IMAGE);
    }

    public static ImageIcon loadStart() {
        return ImageLoader.loadResource(START_IMAGE);
    }

    public static ImageIcon loadQuestionmark() {
        return ImageLoader.loadResource(QUESTIONMARK_IMAGE);
    }

    public static ImageIcon loadClose() {
        return ImageLoader.loadResource(CLOSE_IMAGE);
    }

    private static ImageIcon loadResource(String identifier) {
        URL resUrl = Konverter.class.getResource(identifier);
        if (resUrl == null) {
            Logger.log(ImageLoader.class, "Resource " + identifier + " nicht gefunden!");
            return null;
        }
        return new ImageIcon(resUrl);
    }
}

