/*
 * Decompiled with CFR 0.152.
 */
package de.tass.worker;

import de.tass.model.Buchung;
import de.tass.model.Import;
import de.tass.model.Mandant;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Properties;

public class CollmexParser {
    private static final int SUMMEM_ROW_COUNT = 7;
    private static final String FORM_PATTERN = "^(?i)(<form.+?c\\.cmx\\?)(.+?)(,.*?)$";
    private static final String TD_PATTERN = "^(?i)(</td><td class=.+?>)(.+?)$";
    private static final String TD_ID_PATTERN = "^(?i)(<td class=.+?>)(.+?)$";
    private static final String TD_MULTICOLUMN_PATTERN = "^(?i)(</td><td class=.+?>)(.+?)(</td><td></td><td>)$";
    private static final String IMPORT_START = "<h2>Offene Posten</h2>";
    private static final String FORM_START = "<form";
    private static final String MANDANT_ENDE = "<!-- GroupEnd group end -->";
    private static final String MANDANT_ZELLEN_START = "</td><td class=\"fc";
    private static final String LISTE_START = "<!-- Table table begin -->";
    private static final String BUCHUNG_START_TH = "</th></tr><tr><!-- Line";
    private static final String BUCHUNG_START_TD = "</td></tr><tr><!-- Line";
    private static final String SUMMEN_START = "<td class=\"r\" colspan";
    private static final String ITEM_START = "</td><td class=";
    private static final String ITEM_ID_START = "<td class=";
    private static final String ITEM_MULTICOLUMN_END = "</td><td></td><td>";
    private final File _sourceFile;

    public CollmexParser(Properties cfg) {
        this._sourceFile = new File(cfg.getProperty("lastSourceFile"));
    }

    /*
     * Exception decompiling
     */
    public final Import parse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Mandant collectMandant(BufferedReader br) throws ParseException, IOException {
        String line;
        Mandant mandant = null;
        boolean isReady = false;
        while ((line = br.readLine()) != null && !isReady) {
            if (line.startsWith(FORM_START)) {
                mandant = new Mandant();
                mandant.setId(line.replaceAll(FORM_PATTERN, "$2"));
                continue;
            }
            if (line.startsWith(MANDANT_ZELLEN_START) && mandant.getName() == null) {
                mandant.setName(line.replaceAll(TD_PATTERN, "$2"));
                mandant.setDate(LocalDate.now());
                continue;
            }
            if (!line.startsWith(MANDANT_ENDE)) continue;
            isReady = true;
        }
        if (line == null) {
            throw new ParseException("Fehler in den Kopfdaten!", 0);
        }
        return mandant;
    }

    private ArrayList<Buchung> collectBuchungen(BufferedReader br) throws ParseException, IOException {
        String line;
        ArrayList<Buchung> buchungsListe = new ArrayList<Buchung>();
        Buchung actBuchung = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith(BUCHUNG_START_TH) || line.startsWith(BUCHUNG_START_TD)) {
                if (actBuchung == null) {
                    actBuchung = new Buchung();
                    continue;
                }
                if (!actBuchung.isValid()) {
                    throw new ParseException("Buchung konnte nicht verarbeitet werden.", 0);
                }
                buchungsListe.add(actBuchung);
                Buchung newBuchung = new Buchung();
                newBuchung.setKundenID(actBuchung.getKundenID());
                newBuchung.setName(actBuchung.getName());
                actBuchung = newBuchung;
                continue;
            }
            if (line.startsWith(SUMMEN_START)) {
                actBuchung = null;
                int i = 0;
                while (i < 7) {
                    br.readLine();
                    ++i;
                }
                continue;
            }
            if (line.startsWith(ITEM_ID_START) && actBuchung != null) {
                actBuchung.addItem(line.replaceAll(TD_ID_PATTERN, "$2"), ITEM_ID_START);
                continue;
            }
            if (!line.startsWith(ITEM_START) || actBuchung == null) continue;
            if (line.endsWith(ITEM_MULTICOLUMN_END)) {
                actBuchung.addItem(line.replaceAll(TD_MULTICOLUMN_PATTERN, "$2"), ITEM_START, 3);
                continue;
            }
            actBuchung.addItem(line.replaceAll(TD_PATTERN, "$2"), ITEM_START);
        }
        return buchungsListe;
    }
}

