/*
 * Decompiled with CFR 0.152.
 */
package de.tass.worker;

import de.tass.model.Buchung;
import de.tass.model.Import;
import de.tass.utils.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;

public class DatevCsvWriter {
    private static final String CSV_SEPARATOR = ";";
    private static final String CSV_FILE_SUFFIX = "txt";
    private static final NumberFormat NUMBER_FORMATTER = NumberFormat.getNumberInstance(Locale.GERMAN);
    private static String[] csvHeader;
    private final DateTimeFormatter _dateFormatter = DateTimeFormatter.ofPattern("ddMMyyyy");
    private final File _targetFile;

    static {
        NUMBER_FORMATTER.setMinimumFractionDigits(2);
        NUMBER_FORMATTER.setMaximumFractionDigits(2);
        NUMBER_FORMATTER.setGroupingUsed(false);
        csvHeader = new String[22];
        DatevCsvWriter.csvHeader[0] = "Konto-Nummer;";
        DatevCsvWriter.csvHeader[1] = "Rechnungs-Nr;";
        DatevCsvWriter.csvHeader[2] = "Rechnungsdatum;";
        DatevCsvWriter.csvHeader[3] = "F\u00e4lligkeitsdatum;";
        DatevCsvWriter.csvHeader[4] = "Gegenkonto;";
        DatevCsvWriter.csvHeader[5] = "Betrag Soll;";
        DatevCsvWriter.csvHeader[6] = "Betrag Haben;";
        DatevCsvWriter.csvHeader[7] = "Betrag Saldo;";
        DatevCsvWriter.csvHeader[8] = "Soll/Haben-KZ;";
        DatevCsvWriter.csvHeader[9] = "W\u00e4hrung;";
        DatevCsvWriter.csvHeader[10] = "Urbetrag;";
        DatevCsvWriter.csvHeader[11] = "Urbertrag-Soll-Haben;";
        DatevCsvWriter.csvHeader[12] = "Kurs;";
        DatevCsvWriter.csvHeader[13] = "Raffung;";
        DatevCsvWriter.csvHeader[14] = "F\u00e4lligkeitstage;";
        DatevCsvWriter.csvHeader[15] = "Beleg-Nummer;";
        DatevCsvWriter.csvHeader[16] = "Mahnstufe;";
        DatevCsvWriter.csvHeader[17] = "Buchungstext;";
        DatevCsvWriter.csvHeader[18] = "Umsatzsteuer in Prozent;";
        DatevCsvWriter.csvHeader[19] = "Vorlauf;";
        DatevCsvWriter.csvHeader[20] = "Buchungssatz-Nr;";
        DatevCsvWriter.csvHeader[21] = "Ausgleichs-Kennzeichen";
    }

    public DatevCsvWriter(Properties cfg, String targetFilePrefix) {
        this._targetFile = new File(String.valueOf(cfg.getProperty("lastTargetDir")) + System.getProperty("file.separator") + targetFilePrefix + "." + CSV_FILE_SUFFIX);
    }

    public final void writeCsv(Import theImport) {
        BufferedWriter wr = null;
        try {
            try {
                if (this._targetFile.exists()) {
                    this._targetFile.delete();
                }
                wr = new BufferedWriter(new FileWriter(this._targetFile));
                this.initFile(wr);
                this.writeBuchungen(wr, theImport.getMandant().getBuchungsliste());
            }
            catch (IOException ioe) {
                Logger.log(this.getClass(), ioe.toString());
                theImport.setWorkflowStatus(10);
                try {
                    if (wr != null) {
                        wr.flush();
                        wr.close();
                    }
                }
                catch (IOException ioe2) {
                    Logger.log(this.getClass(), ioe2.toString());
                }
            }
            catch (Exception e) {
                Logger.log(this.getClass(), e.toString());
                theImport.setWorkflowStatus(99);
                try {
                    if (wr != null) {
                        wr.flush();
                        wr.close();
                    }
                }
                catch (IOException ioe) {
                    Logger.log(this.getClass(), ioe.toString());
                }
            }
        }
        finally {
            try {
                if (wr != null) {
                    wr.flush();
                    wr.close();
                }
            }
            catch (IOException ioe) {
                Logger.log(this.getClass(), ioe.toString());
            }
        }
    }

    public final boolean targetFileExists() {
        return this._targetFile.exists();
    }

    private void initFile(BufferedWriter wr) throws IOException {
        int i = 0;
        while (i < csvHeader.length) {
            wr.write(csvHeader[i]);
            ++i;
        }
        wr.newLine();
    }

    private void writeBuchungen(BufferedWriter wr, ArrayList<Buchung> buchungsliste) throws IOException {
        if (buchungsliste != null && buchungsliste.size() > 0) {
            int i = 0;
            while (i < buchungsliste.size()) {
                Buchung buchung = buchungsliste.get(i);
                wr.write(String.valueOf(buchung.getKundenID()) + CSV_SEPARATOR);
                wr.write(String.valueOf(this.formatText(buchung.getRechnungsNr())) + CSV_SEPARATOR);
                wr.write(String.valueOf(this.formatDate(buchung.getDatum())) + CSV_SEPARATOR);
                wr.write(String.valueOf(this.formatDate(buchung.getFaelligkeit())) + CSV_SEPARATOR);
                wr.write(String.valueOf(buchung.getGegenKontoNr()) + CSV_SEPARATOR);
                if (buchung.getBezahlt() >= 0.0) {
                    wr.write(String.valueOf(NUMBER_FORMATTER.format(buchung.getBezahlt())) + CSV_SEPARATOR);
                    wr.write(String.valueOf(NUMBER_FORMATTER.format(0.0)) + CSV_SEPARATOR);
                } else {
                    wr.write(String.valueOf(NUMBER_FORMATTER.format(0.0)) + CSV_SEPARATOR);
                    wr.write(String.valueOf(NUMBER_FORMATTER.format(buchung.getBezahlt())) + CSV_SEPARATOR);
                }
                wr.write(String.valueOf(NUMBER_FORMATTER.format(buchung.getOffen())) + CSV_SEPARATOR);
                if (buchung.getBezahlt() >= 0.0) {
                    wr.write("S;");
                } else {
                    wr.write("H;");
                }
                wr.write(String.valueOf(buchung.getWaehrung()) + CSV_SEPARATOR);
                wr.write(String.valueOf(NUMBER_FORMATTER.format(buchung.getBetrag())) + CSV_SEPARATOR);
                if (buchung.getBetrag() >= 0.0) {
                    wr.write("S;");
                } else {
                    wr.write("H;");
                }
                wr.write(String.valueOf(NUMBER_FORMATTER.format(buchung.getKurs())) + CSV_SEPARATOR);
                wr.write(String.valueOf(buchung.getRaffung()) + CSV_SEPARATOR);
                wr.write(String.valueOf(buchung.getVerzug()) + CSV_SEPARATOR);
                wr.write(String.valueOf(buchung.getBelegNr()) + CSV_SEPARATOR);
                if (buchung.getMahnungen() != null) {
                    int len = buchung.getMahnungen().length();
                    wr.write(String.valueOf(buchung.getMahnungen().substring(len - 1, len)) + CSV_SEPARATOR);
                } else {
                    wr.write("X;");
                }
                wr.write(String.valueOf(buchung.getText()) + CSV_SEPARATOR);
                wr.write(String.valueOf(NUMBER_FORMATTER.format(buchung.getUst())) + CSV_SEPARATOR);
                wr.write(String.valueOf(buchung.getVorlauf()) + CSV_SEPARATOR);
                wr.write(String.valueOf(buchung.getBuchungsSatzNr()) + CSV_SEPARATOR);
                wr.write(String.valueOf(buchung.getAusgleichsKennzeichen()) + CSV_SEPARATOR);
                wr.newLine();
                ++i;
            }
        }
    }

    private String formatDate(LocalDate date) {
        if (date != null) {
            return date.format(this._dateFormatter);
        }
        return "";
    }

    private String formatText(String str) {
        if (str != null) {
            return str.trim();
        }
        return "";
    }
}

